<?php
namespace app\admin\controller\rapac;
use app\BaseController;
use app\common\model\rapac\RapacModel;
class  Rapac extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['name','LIKE','%'.$keyword.'%'];
        }
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        
        $type = $this->request->param('type/d');
        if(!empty($type)){
            if($type == 1){
                $where[] = ['is_audit','=',0];
            }else{
                $where[] = ['is_audit','=',1];
            }
        }
        
        $return['count'] = RapacModel::where($where)->count();
        $return['datas'] = RapacModel::with(['city','member'])->where($where)
                           ->order(['rapac_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
   
    
    public function del(){
        $rapacId = $this->request->param('rapacId/d');
        if(empty($rapacId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $rapac = RapacModel::find($rapacId)){
            return $this->error('请选择要删除的数据');
        }
        $rapac->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $rapacIds = $this->request->param('rapacIds/a');
        if(empty($rapacIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($rapacIds as $key=>$val){
            $rapacIds[$key] = (int)$val;
        }
        RapacModel::where([
            ['rapac_id','IN',$rapacIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $rapacId = $this->request->param('rapacId/d');
        $datas = [
            'name'    => $this->request->param('name'),
            'photos'      => $this->request->param('photos/a'),
            'desc'        => $this->request->param('desc'),  
            'lat'         => $this->request->param('lat'),
            'lng'         => $this->request->param('lng'),
            'member_id'   => $this->request->param('member_id'),  
            'city_id'     => $this->request->param('city_id/d'),
            'is_cat'     => $this->request->param('is_cat/d'),
            'is_lure'      => $this->request->param('is_lure/d'),  
            'is_audit'      => $this->request->param('is_audit/d'),  
            'fish_type'   => $this->request->param('fish_type/a'),
        ];
        if(empty($datas['name'])){
            return $this->error('请填写野钓名称');
        }
        if(empty($datas['photos'])){
            return $this->error('请上传图片');
        }
        if(empty($datas['desc'])){
            return $this->error('请填写钓点说明');
        }
        if(empty($datas['lat']) || empty($datas['lng'])){
            return $this->error('请选择钓点的经纬度坐标');
        }
        if(!empty($rapacId)){
            if(null === $rapac = RapacModel::find($rapacId)){
                return $this->error('请选择要编辑的用户');
            }
        }else{
            $rapac = new RapacModel();
        }
        
        $rapac->save($datas);
        return $this->success();
     
     
    }
    
}