<?php
namespace app\admin\controller\oss;
use app\BaseController;
use think\Exception;
use app\common\helper\oss\OssHelper;
use app\common\model\data\AlbumModel;
use app\common\model\data\ImageModel;
class Index extends BaseController{

    
    //上传文件 后台的上传图片
    public function upload(){
        try{
            if(empty($_FILES['file'])){
                  throw new Exception('请上传图片');
            }
            $OssHelper = new OssHelper();
            $albumId = $this->request->param('albumId/d',0);
            $albumId = $albumId == -1 ? 0 : $albumId;
        
            foreach($_FILES['file']['name'] as $k=>$v){
                $file = [
                    'name' => $v,
                    'full_path' => $_FILES['file']['full_path'][$k],
                    'type'      => $_FILES['file']['type'][$k],
                    'tmp_name'      => $_FILES['file']['tmp_name'][$k],
                    'error'      => $_FILES['file']['error'][$k],
                    'size'      => $_FILES['file']['size'][$k],
                ];
      
                $res = $OssHelper->upload($file);            
                //写入数据库
                $ImageModel = new ImageModel();
                $ImageModel->save([
                    'album_id'  => $albumId,
                    'from_type' => 'admin',
                    'member_id' => 0,
                    'hash'      => $res['hash'],
                    'key'       => $res['key'],
                    'url'       => $res['url'],
                    'size'      => $res['size'],
                    'ext'       => $res['ext'],
                ]);
            }
           
            return $this->success();
        }  catch (Exception $e){
            return $this->error($e->getMessage());
        }
    }
    
    public function  saveAlbum(){
        $albums = AlbumModel::column('album_id');
        $formdata = $this->request->param('data','','security_json_or_array');
        $ids = $update =  $add = [];
        foreach($formdata as $val){
            if(empty($val['name'])){
                return $this->error('相册名称不能为空');
            }
            if($val['album_id'] > 0){
                $ids[] = $val['album_id'];
                $update [] = $val;
            }else{
                $add[] = ['name'=>$val['name']];
            }
        }
        $delIds = [];
        foreach($albums as $val){
            if(!in_array($val, $ids)){
                $delIds[] = $val;
            }
        }
        if(!empty($delIds)){
            $AlbumModel = new AlbumModel();
            $AlbumModel->where([
                ['album_id','IN',$delIds]
            ])->delete();
        }
        if(!empty($update)){
            $AlbumModel = new AlbumModel();
            $AlbumModel->saveAll($update);
        }
        if(!empty($add)){
            $AlbumModel = new AlbumModel();
            $AlbumModel->saveAll($add);
        }
        return $this->success('保存成功');        
    }
    
    public function getList(){
        $albumId = $this->request->param('albumId/d',-1);
        $keyword = $this->request->param('keyword');
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $where = [
            ['is_delete','=',0],
            ['member_id','=',0],
            ['from_type','=','admin'],
        ];
        switch ($albumId){
            case -1: //没条件
                break;
            case 0:
                $where[] = ['album_id','=',0];
                break;
            default :
                $where[] = ['album_id','=',$albumId];
                break;
        }
        if(!empty($keyword)){
            $where[] = ['url','LIKE','%'.$keyword.'%'];
        }
        $albums = AlbumModel::select()->toArray();
        $count = ImageModel::where($where)->count();
        $datas = ImageModel::where($where)
                           ->limit($limit)->page($page)
                           ->order(['add_time'=>'desc'])
                           ->select()
                           ->toArray();
        return $this->success([
            'albums' => $albums,
            'count'  => $count,
            'datas'  => $datas,
        ]);
    }
    
    public  function  movePhoto(){
        $imgs = $this->request->param('imgs/a');
        if(empty($imgs)){
           return $this->error('请选择要移动的图片'); 
        }
        $albumId = $this->request->param('albumId/d');
        if(empty($albumId)){
            return $this->error('请选择要移动的目标相册');
        }
         $where = [
            ['from_type','=','admin'],
            ['is_delete','=',0],
            ['url','IN',$imgs]
        ];
        ImageModel::where($where)->save([
            'album_id' =>$albumId
        ]);
        return $this->success('移动成功');
    }
    public function   deletePhoto(){
        $imgs = $this->request->param('imgs/a');
        if(empty($imgs)){
           return $this->error('请选择要删除的图片'); 
        }
        $where = [
            ['from_type','=','admin'],
            ['is_delete','=',0],
            ['url','IN',$imgs]
        ];
        ImageModel::where($where)->save([
            'is_delete' => 1
        ]);
        return $this->success('删除成功');
    }    
   
}