<?php
namespace app\admin\controller\order;
use app\BaseController;
use app\common\model\order\OrderModel;
use app\common\model\angling\MoneyLogModel;
use app\common\helper\miniapp\PaymentHelper;
class Order extends BaseController{
    
    public function index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['order_id|title','LIKE','%'.$keyword.'%'];
        }
        $memberId = $this->request->param('memberId/d');
        if(!empty($memberId)){
            $where[] = ['member_id','=',$memberId];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        $status = $this->request->param('status/d');
        switch($status){
             case 0: //全部
                break;
            case 1://待使用
                $where[] = ['is_paid','=',1];
                $where[] = ['status','=',0];
                break;
            case 2: //退款中
                $where[] = ['is_paid','=',1];
                $where[] = ['status','=',2];
                break;
            case 3://已使用
                $where[] = ['is_paid','=',1];
                $where[] = ['status','=',8];
                break;
            case 4: //已取消
                $where[] = ['status','IN',[3,4]];
                break;
            default :
                break;
        }
        $return['count'] = OrderModel::where($where)->count();
        $return['datas'] =  OrderModel::with([
            'member','angling'
        ])->where($where) ->order(['order_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        
        return $this->success($return);
    }

    public function refundYes(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要查看的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要查看的订单');
        }
        if($order->status !=2 || $order->is_paid != 1){
            return $this->error('该订单状态不能退款');
        }
        $money = round($this->request->param('money/f'),2);
        if($money < 0){ 
            return $this->error('请选择要退款的金额');
        }
        $order->status = 3;
        $order->save();
        $money2 = round(($order->need_pay * 100 - $money * 100)/100,2);
        if($money2 > 0){
            $MoneyLogModel = new MoneyLogModel();
            $MoneyLogModel->save([
                'angling_id' => $order->angling_id,
                'money' => $money2,
                'order_id' => $orderId,
                'status' => 0
            ]);
        }
        if($money > 0){
            $PaymentHelper = new PaymentHelper();
            $PaymentHelper->refund($order->pay_info,$money);
        }
        return $this->success();
        
        
    }
    public function refundNo(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要查看的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要查看的订单');
        }
        if($order->status !=2 || $order->is_paid != 1){
            return $this->error('该订单状态不能退款');
        }
        $order->status = 0;
        $order->save();
        return $this->success();
    }
    
}