<?php
namespace app\admin\controller\member;
use app\BaseController;
use app\common\model\member\MemberModel;
class  Member extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['mobile|nickname|open_id','LIKE','%'.$keyword.'%'];
        }
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        $where[] = ['is_delete','=',0];
        $return['count'] = MemberModel::where($where)->count();
        $return['datas'] = MemberModel::with(['city'])->where($where)->field('member_id,open_id,city_id,face,mobile,nickname,integral,is_new,add_time')
                           ->order(['member_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
   
    
    public function del(){
        $memberId = $this->request->param('memberId/d');
        if(empty($memberId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $member = MemberModel::find($memberId)){
            return $this->error('请选择要删除的数据');
        }
        $member->save([
            'is_delete' => 1
        ]);
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $memberIds = $this->request->param('memberIds/a');
        if(empty($memberIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($memberIds as $key=>$val){
            $memberIds[$key] = (int)$val;
        }
        MemberModel::where([
            ['member_id','IN',$memberIds]
        ])->save([
            'is_delete'=>0
        ]);
        return $this->success('操作成功');
    }
    
    public function save(){
        $memberId = $this->request->param('memberId/d');
        $datas = [
            'nickname'    => $this->request->param('nickname'),
            'mobile'      => $this->request->param('mobile'),
            'face'        => $this->request->param('face'),  
            'open_id'     => $this->request->param('open_id'),
           
            'city_id'     => $this->request->param('city_id/d'),
            'is_new'      => $this->request->param('is_new/d'),  
        ];
        if(empty($datas['nickname'])){
            return $this->error('请输入用户昵称');
        }
        if(!is_mobile($datas['mobile'])){
            return $this->error('请输入用户手机号');
        } 
        if(!empty($memberId)){
            if(null === $member = MemberModel::find($memberId)){
                return $this->error('请选择要编辑的用户');
            }
        }else{
            $member = new MemberModel();
        }
        
        $member->save($datas);
        return $this->success();
     
     
    }
    
}