<?php
namespace app\admin\controller\member;
use app\BaseController;
use app\common\model\member\IntegralModel;
use app\common\model\member\MemberModel;
use app\common\logic\member\IntegralLogic;
class  Integral extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['info','LIKE','%'.$keyword.'%'];
        }
        $memberId = $this->request->param('memberId/d');
        if(!empty($memberId)){
            $where[] = ['member_id','=',$memberId];
        }
        
        $return['count'] = IntegralModel::where($where)->count();
        $return['datas'] = IntegralModel::with(['member'])->where($where)
                           ->order(['log_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    public function save(){
        $type = $this->request->param('type/d');
        $info = $this->request->param('info');
        $memberId = $this->request->param('memberId/d');
        $num = $this->request->param('num/d');
        if(empty($type)){
            return $this->error('请选择操作类型');
        }
        if(empty($info)){
            return $this->error('请填写积分变动原因');
        }
        if(empty($memberId)){
            return $this->error('请选择用户');
        }
        if(empty($num)){
            return $this->error('请填写积分数量');
        }
        if(null === $member = MemberModel::find($memberId)){
            return $this->error('用户不存在');
        }
        if($type == 2){
            if($member->integral < $num){
                return $this->error('账户积分不够');
            }
            IntegralLogic::getInstance()->useIntegral($memberId,$num,$info);
        }else{
            IntegralLogic::getInstance()->addIntegral($memberId,$num,$info);
        }
        return $this->success();
    }
    
}