<?php
namespace app\admin\controller\member;
use app\BaseController;
use app\common\model\member\ClockModel;
class  Clock extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['desc','LIKE','%'.$keyword.'%'];
        }
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        
        $type = $this->request->param('type/d');
        if(!empty($type)){
            if($type == 1){
                $where[] = ['status','=',0];
            }else{
                $where[] = ['status','=',1];
            }
        }
        
        $return['count'] = ClockModel::where($where)->count();
        $return['datas'] = ClockModel::with(['city','member','angling','rapac'])->where($where)
                           ->order(['clock_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    public function audit(){
        $clockIds = $this->request->param('clockIds/a');
        if(empty($clockIds)){
            return $this->error('请选择要审核的数据');
        }
        foreach($clockIds as $key=>$val){
            $clockIds[$key] = (int)$val;
        }
        ClockModel::where([
            ['clock_id','IN',$clockIds]
        ])->save(['status'=>1]);
        return $this->success('操作成功');
    }
    
    public function del(){
        $clockId = $this->request->param('clockId/d');
        if(empty($clockId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $clock = ClockModel::find($clockId)){
            return $this->error('请选择要删除的数据');
        }
        $clock->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $clockIds = $this->request->param('clockIds/a');
        if(empty($clockIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($clockIds as $key=>$val){
            $clockIds[$key] = (int)$val;
        }
        ClockModel::where([
            ['clock_id','IN',$clockIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $clockId = $this->request->param('clockId/d');
        $datas = [
            'desc'    => $this->request->param('desc'),
            'photos'      => $this->request->param('photos/a'),
            'member_id'   => $this->request->param('member_id'),  
            'city_id'     => $this->request->param('city_id/d'),
            'type'     => $this->request->param('type/d'),
            'angling_id'     => $this->request->param('angling_id/d'),
            'rapac_id'     => $this->request->param('rapac_id/d'),
            'status'        => $this->request->param('status/d'),
        ];
        if(empty($datas['desc'])){
            return $this->error('请说点什么');
        }
        if(empty($datas['photos'])){
            return $this->error('请上传图片');
        }     
        if(!empty($clockId)){
            if(null === $clock = ClockModel::find($clockId)){
                return $this->error('请选择要编辑的打卡记录');
            }
        }else{
            $clock = new ClockModel();
        }
        
        $clock->save($datas);
        return $this->success();
     
     
    }
    
}