<?php
namespace app\admin\controller\market;
use app\BaseController;
use app\common\model\market\LotteryModel;
use app\common\model\market\LotteryJoinModel;
use app\common\logic\member\IntegralLogic;
class Lottery extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['title','LIKE','%'.$keyword.'%'];
        }
      
        $return['count'] = LotteryModel::where($where)->count();
        $datas =  LotteryModel::where($where)
                           ->order(['lottery_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        $time = time();
        foreach($datas as $key=>$val){
            $bg = strtotime($val['bg_time']) - $time;
            $open = strtotime($val['open_time']) - $time;
            if($val['status'] == 0){
                if($open <= 0){
                    $val['status_means'] = '等待开奖';
                }elseif($bg <= 0){
                    $val['status_means'] = '正在进行';
                }else{
                    $val['status_means'] = '即将开始';
                }
            }else{
                $val['status_means'] = '已开奖';
            }
            $datas[$key] = $val;
        }
        $return['datas'] = $datas;
        
        
        return $this->success($return);
    }
    
    public function rewards(){
        $lotteryId = $this->request->param('lotteryId/d');
        if(empty($lotteryId)){
            return $this->error('要开奖的活动不存在');
        }
        if(null === $lottery = LotteryModel::find($lotteryId)){
            return $this->error('要开奖的活动不存在');
        }
        if($lottery->status != 0){
            return $this->error('要开奖的活动不存在');
        }
        if(strtotime($lottery->open_time) - time() > 0){
            return $this->error('开奖时间还没到');
        }
        $lottery->status = 8;
        $lottery->save();
        $memberIds = LotteryJoinModel::where([
            ['lottery_id','=',$lotteryId]
        ])->order(['rate'=>'desc','id'=>'asc'])->limit($lottery->luck_num)->column('member_id');
        if(empty($memberIds)){
            return $this->success('操作成功');
        }
        $luckIds = $memberIds;
        $dxId = $memberIds[0];
        unset($luckIds[0]);
        LotteryJoinModel::where([
            ['lottery_id','=',$lotteryId],
            ['member_id','=',$dxId]
        ])->save(['status'=>1]);
        IntegralLogic::getInstance()->addIntegral($dxId,$lottery->exclusive,'领取鱼饵独享大奖');
        if(!empty($luckIds)){
            LotteryJoinModel::where([
                ['lottery_id','=',$lotteryId],
                ['member_id','IN',$luckIds]
            ])->save(['status'=>2]);
            IntegralLogic::getInstance()->addIntegral($luckIds, rand($lottery->luck_min,$lottery->max),'领取鱼饵幸运大奖');
        }
        LotteryJoinModel::where([
                ['lottery_id','=',$lotteryId],
                ['member_id','NOT IN',$memberIds]
        ])->save(['status'=>4]);
        return $this->success();
    }
    public function getJoinList(){
        $lotteryId = $this->request->param('lotteryId/d');
        if(empty($lotteryId)){
            return $this->error('您访问的领取鱼饵活动不存在');
        }
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $count = LotteryJoinModel::where([
            ['lottery_id','=',$lotteryId]
        ])->count();
        $datas  = LotteryJoinModel::with(['member'=>function($query){
            $query->field('member_id,nickname,face');
        }])->where([
            ['lottery_id','=',$lotteryId]
        ])->order(['rate'=>'desc','id'=>'asc'])->limit($limit)->page($page)->select()->toArray();

        return $this->success([
            'datas' => $datas,
            'count'  => $count
        ]);
    }
    public function del(){
        $lotteryId = $this->request->param('lotteryId/d');
        if(empty($lotteryId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $lottery = LotteryModel::find($lotteryId)){
            return $this->error('请选择要删除的数据');
        }
        $lottery->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $lotteryIds = $this->request->param('lotteryIds/a');
        if(empty($lotteryIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($lotteryIds as $key=>$val){
            $lotteryIds[$key] = (int)$val;
        }
        LotteryModel::where([
            ['lottery_id','IN',$lotteryIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $lotteryId = $this->request->param('lotteryId/d');
        $datas = [
            'title'      => $this->request->param('title'),   
            'exclusive'      => $this->request->param('exclusive/d'),
            'luck_num'      => $this->request->param('luck_num/d'),
            'luck_min'     => $this->request->param('luck_min/d'),
            'luck_max'     => $this->request->param('luck_max/d'),
            'bg_time'  => $this->request->param('bg_time'),
            'open_time' => $this->request->param('open_time'),
        ];
      
        if(empty($datas['title'])){
            return $this->error('请填写标题');
        }
        if(empty($datas['exclusive'])){
            return $this->error('请填写独享鱼饵');
        }
        if(empty($datas['luck_num'])){
            return $this->error('请填写幸运奖数量');
        }
        if(!empty($lotteryId)){
            if(null === $lottery = LotteryModel::find($lotteryId)){
                return $this->error('请选择要编辑的数据');
            }
        }else{
            $lottery = new LotteryModel();
        }
        $lottery->save($datas);
        return $this->success();
    }
    
}