<?php
namespace app\admin\controller\market;
use app\BaseController;
use app\common\model\market\CouponModel;
class Coupon extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['title','LIKE','%'.$keyword.'%'];
        }
      
        $return['count'] = CouponModel::where($where)->count();
        $return['datas'] = CouponModel::where($where)
                           ->order(['coupon_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    public function del(){
        $couponId = $this->request->param('couponId/d');
        if(empty($couponId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $coupon = CouponModel::find($couponId)){
            return $this->error('请选择要删除的数据');
        }
        $coupon->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $couponIds = $this->request->param('couponIds/a');
        if(empty($couponIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($couponIds as $key=>$val){
            $couponIds[$key] = (int)$val;
        }
        CouponModel::where([
            ['coupon_id','IN',$couponIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $couponId = $this->request->param('couponId/d');
        $datas = [
            'title'      => $this->request->param('title'),   
            'money'      => round($this->request->param('money/f'),2),
            'need_money'      => round($this->request->param('need_money/f'),2),
            'num'       => $this->request->param('num/d'),
            'bg_time'  => $this->request->param('bg_time'),
            'day' => $this->request->param('day/d'),
            'type'   => $this->request->param('type/d'),
            'exchange_num' => $this->request->param('exchange_num/d'),
        ];
      
        if(empty($datas['title'])){
            return $this->error('请填写平台补贴券标题');
        }
        if(empty($datas['money'])){
            return $this->error('请填写补贴券面值');
        }
        if(!empty($couponId)){
            if(null === $coupon = CouponModel::find($couponId)){
                return $this->error('请选择要编辑的数据');
            }
        }else{
            $coupon = new CouponModel();
        }
        $coupon->save($datas);
        return $this->success();
    }
    
}