<?php
namespace app\admin\controller\huodong;
use app\BaseController;
use app\common\model\market\HuodongModel;
class Huodong extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['title','LIKE','%'.$keyword.'%'];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        $status = $this->request->param('status/d');
        if(!empty($status)){
            $status = $status == 999 ? 0 : $status;
            $where[] = ['status','=',$status];
        }
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        
        $return['count'] = HuodongModel::where($where)->count();
        $return['datas'] = HuodongModel::with(['angling'=>function($query){
            $query->field('angling_id,name');
        },'city'])->where($where)
                           ->order(['huodong_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    
    public function detail(){
        $huodongId = $this->request->param('huodongId/d');
        if(empty($huodongId)){
            return $this->error('请选择要编辑的数据');
        }
        if(null === $huodong = HuodongModel::find($huodongId)){
            return $this->error('请选择要编辑的数据');
        }
        return $this->success([
            'detail' => [
                'huodongId' => $huodong->huodong_id,
                'angling_id' => $huodong->angling_id,
                'angling_name' => $huodong->angling ? $huodong->angling->name:'',
                'title'     => $huodong->title,
                'photo'     => $huodong->photo,
                'original_price' => $huodong->original_price,
                'price'     => $huodong->price,
                'city_id'   => $huodong->city_id,
                'num'       => $huodong->num,
                'fishing_day' => $huodong->fishing_day,
                'detail'  => $huodong->detail,
                'status'   => $huodong->status,
                'day'      => $huodong->day,
                'hour'     => $huodong->hour,
                'day_refund' => $huodong->day_refund,
                'hour_refund'  => $huodong->hour_refund,
                
            ]
        ]);
    }
   
    
    public function del(){
        $huodongId = $this->request->param('huodongId/d');
        if(empty($huodongId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $huodong = HuodongModel::find($huodongId)){
            return $this->error('请选择要删除的数据');
        }
        $huodong->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $huodongIds = $this->request->param('huodongIds/a');
        if(empty($huodongIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($huodongIds as $key=>$val){
            $huodongIds[$key] = (int)$val;
        }
        HuodongModel::where([
            ['huodong_id','IN',$huodongIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $huodongId = $this->request->param('huodongId/d');
        $datas = [
            'angling_id'    => $this->request->param('angling_id/d'),
            'title'      => $this->request->param('title'),   
            'photo'      => $this->request->param('photo'),
            'price'      => round($this->request->param('price/f'),2),
            'original_price'      => round($this->request->param('original_price/f'),2),
            'city_id'       => $this->request->param('city_id/d'),
            'num'       => $this->request->param('num/d'),
            'fishing_day'       => $this->request->param('fishing_day'),
            'detail'        => $this->request->param('detail'),
            'status' => $this->request->param('status/d'),
            'day' => $this->request->param('day/d'),
            'hour' => $this->request->param('hour/d'),
            'day_refund' => round($this->request->param('day_refund/f'),2),
            'hour_refund' => round($this->request->param('hour_refund/f'),2),
        ];
        if(empty($datas['angling_id'])){
            return $this->error('请选择黑坑商家');
        }
        if(empty($datas['title'])){
            return $this->error('请填写团购标题');
        }
        if(empty($datas['photo'])){
            return $this->error('请上传活动图片');
        }
        if(empty($datas['fishing_day'])){
            return $this->error('请选择垂钓日期');
        }
        if(!empty($huodongId)){
            if(null === $huodong = HuodongModel::find($huodongId)){
                return $this->error('请选择要编辑的数据');
            }
        }else{
            $huodong = new HuodongModel();
        }
        $huodong->save($datas);
        return $this->success();
    }
   
}