<?php
namespace app\admin\controller\explore;
use app\BaseController;
use app\common\model\market\ExploreModel;
class Explore extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['title','LIKE','%'.$keyword.'%'];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        $status = $this->request->param('status/d');
        if(!empty($status)){
            $status = $status == 999 ? 0 : $status;
            $where[] = ['status','=',$status];
        }
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        
        $return['count'] = ExploreModel::where($where)->count();
        $return['datas'] = ExploreModel::with(['angling'=>function($query){
            $query->field('angling_id,name');
        },'city'])->where($where)
                           ->order(['explore_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    
    public function detail(){
        $exploreId = $this->request->param('exploreId/d');
        if(empty($exploreId)){
            return $this->error('请选择要编辑的数据');
        }
        if(null === $explore = ExploreModel::find($exploreId)){
            return $this->error('请选择要编辑的数据');
        }
        return $this->success([
            'detail' => [
                'exploreId' => $explore->explore_id,
                'angling_id' => $explore->angling_id,
                'angling_name' => $explore->angling ? $explore->angling->name:'',
                'title'     => $explore->title,
                'photo'     => $explore->photo,
                'original_price' => $explore->original_price,
                'price'     => $explore->price,
            
                'city_id'   => $explore->city_id,
                'num'       => $explore->num,
                'detail'  => $explore->detail,
                'status'   => $explore->status,
            ]
        ]);
    }
   
    
    public function del(){
        $exploreId = $this->request->param('exploreId/d');
        if(empty($exploreId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $explore = ExploreModel::find($exploreId)){
            return $this->error('请选择要删除的数据');
        }
        $explore->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $exploreIds = $this->request->param('exploreIds/a');
        if(empty($exploreIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($exploreIds as $key=>$val){
            $exploreIds[$key] = (int)$val;
        }
        ExploreModel::where([
            ['explore_id','IN',$exploreIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $exploreId = $this->request->param('exploreId/d');
        $datas = [
            'angling_id'    => $this->request->param('angling_id/d'),
            'title'      => $this->request->param('title'),   
            'photo'      => $this->request->param('photo'),
            'price'      => round($this->request->param('price/f'),2),
            'original_price'      => round($this->request->param('original_price/f'),2),
          
            'city_id'       => $this->request->param('city_id/d'),
            'num'       => $this->request->param('num/d'),
            'detail'        => $this->request->param('detail'),
            'status' => $this->request->param('status/d'),
         
        ];
        if(empty($datas['angling_id'])){
            return $this->error('请选择黑坑商家');
        }
        if(empty($datas['title'])){
            return $this->error('请填写标题');
        }
        if(empty($datas['photo'])){
            return $this->error('请上传活动图片');
        }
        if(!empty($exploreId)){
            if(null === $explore = ExploreModel::find($exploreId)){
                return $this->error('请选择要编辑的数据');
            }
        }else{
            $explore = new ExploreModel();
        }
        $explore->save($datas);
        return $this->success();
    }
   
}