<?php
namespace app\admin\controller\data;
use app\BaseController;
use app\common\model\data\SettingModel;
use app\common\logic\setting\SettingLogic;
use app\common\helper\oss\OssHelper;
use app\common\helper\mp\MpHelper;
class Setting extends BaseController{
    
    //同步公众号的菜单
    public function createMpMenu(){
        if(null === $data = SettingModel::where([['k','=','mpmenu']])->find()){
            return $this->error('请设置公众号菜单');
        }
        $menus = $data->v;
        if(empty($menus) && empty($menus['button'])){
            return $this->error('请设置公众号菜单');
        }
        $res = MpHelper::getInstance()->saveMenu($menus['button']);
       // wyuLog('txt.txt', var_export($res,true));
        return $this->success();
    }

    
    public function detail(){
        $key = $this->request->param('k');
        
        if(null === $data = SettingModel::where([['k','=',$key]])->find()){
            return $this->success(null);
        }
        return $this->success([
            'setting' => $data->v,
        ]);
    }
    
    //获取URL的设置
    public function  getDomain(){
        $domain = rtrim(env('base_url'),'\/');
        $OssHelper = new OssHelper();
        $imgUrl = $OssHelper->getUrl();
        $type = $OssHelper->getType();
        return $this->success([
            'domain' => [
                'request'   => $domain,
                'upload'    => $domain,
                'download'  => $type == 0 ? $domain :  $domain.';'.$imgUrl,
                'mpurl'     => $domain.'/mp/serve',
                'mpdir'     => $domain.'/mp/payment/'
            ]
        ]);
    }
    
    public function save(){
        $key = $this->request->param('k');
        $val = $this->request->param('v','','security_json_or_array');
        //不一一校验VAL
        if(empty($key)){
            return $this->error('请选择要保存的配置');
        }
        if(empty($val)){
            return $this->error('请配置内容');
        } 
        if(null === $data = SettingModel::where([['k','=',$key]])->find()){
            $model = new SettingModel();
            $model->save([
                'k' => $key,
                'v' => $val,   
            ]);
        }else{
            $data->v = $val;
            $data->save();
        }
        //清除缓存
        SettingLogic::getInstance()->clearCached();
        return $this->success('保存成功');
    }   
}
