<?php
namespace app\admin\controller\data;
use app\BaseController;
use app\common\model\mp\KeywordModel;
class  Mpkeyword extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['keyword','LIKE','%'.$keyword.'%'];
        }
        $return['count'] = KeywordModel::where($where)->count();
        $return['datas'] = KeywordModel::where($where)->field('keyword_id,keyword,type')
                           ->order(['keyword_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()
                           ->toArray();
        return $this->success($return);
    }
    
    public function detail(){
        $keywordId = $this->request->param('keywordId/d');
        if(empty($keywordId)){
            return $this->error('您要获取的数据不存在');
        }
        if(null === $keyword = KeywordModel::find($keywordId)){
            return $this->error('您要获取的数据不存在');
        }
        return $this->success([
            'detail' => [
                'keywordId'  => $keyword->keyword_id,
                'keyword'    => $keyword->keyword,
                'type'       => $keyword->type,
                'content'    => $keyword->content,
                'title'      => $keyword->title,
                'desc'       => $keyword->desc,
                'photo'      => $keyword->photo,
                'url'        => $keyword->url,   
            ],
        ]);
    }
    
    public function del(){
        $keywordId = $this->request->param('keywordId/d');
        if(empty($keywordId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $keyword = KeywordModel::find($keywordId)){
            return $this->error('请选择要删除的数据');
        }
        $keyword->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $keywordIds = $this->request->param('keywordIds/a');
        if(empty($keywordIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($keywordIds as $key=>$val){
            $keywordIds[$key] = (int)$val;
        }
        KeywordModel::where([
            ['keyword_id','IN',$keywordIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $keywordId = $this->request->param('keywordId/d');
        $datas = [
            'keyword'    => $this->request->param('keyword'),
            'type'       => $this->request->param('type'),
            'content'    => $this->request->param('content'),
            'title'      => $this->request->param('title'),
            'desc'       => $this->request->param('desc'),
            'photo'      => $this->request->param('photo'),
            'url'        => $this->request->param('url'),   
        ];
        if(empty($datas['keyword'])){
            return $this->error('请输入关键字');
        }
        if(empty($datas['type'])){
            return $this->error('请选择回复类型');
        }
        if($datas['type'] == 'text'){
            if(empty($datas['content'])){
                return $this->error('请填写回复内容');
            }
        }else{
            if(empty($datas['title']) || empty($datas['desc']) || empty($datas['photo']) || empty($datas['url'])){
                return $this->error('请填写回复内容');
            }
        }
        
        if(!empty($keywordId)){
            if(null === $keyword = KeywordModel::find($keywordId)){
                return $this->error('请选择要编辑的关键字');
            }
        }else{
            $keyword = new KeywordModel();
        }
        $keyword->save($datas);
        return $this->success();
    }
    
}