<?php
namespace app\admin\controller\data;
use app\BaseController;
use app\common\model\data\CityModel;
class  City extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['name','LIKE','%'.$keyword.'%'];
        }
        $return['count'] = CityModel::where($where)->count();
        $return['datas'] = CityModel::where($where)->field('city_id,name,is_open,is_hot,lat,lng')
                           ->order(['city_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()
                           ->toArray();
        return $this->success($return);
    }
    
    public  function datas(){
        
       $datas =  CityModel::field('city_id,name,is_open')
                           ->order(['city_id'=>'desc']) 
                           ->select()
                           ->toArray();
       return $this->success([
           'datas' => $datas
       ]); 
    }


    public function detail(){
        $cityId = $this->request->param('cityId/d');
        if(empty($cityId)){
            return $this->error('您要获取的数据不存在');
        }
        if(null === $city = CityModel::find($cityId)){
            return $this->error('您要获取的数据不存在');
        }
        return $this->success([
            'detail' => [
                'cityId'     => $city->city_id,
                'name'       => $city->name,
                'lat'        => $city->lat,
                'lng'        => $city->lng,
                'is_open'    => $city->is_open,
                'is_hot'     => $city->is_hot,
                'qun'        => $city->qun,
            ],
        ]);
    }
    
    public function del(){
        $cityId = $this->request->param('cityId/d');
        if(empty($cityId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $city = CityModel::find($cityId)){
            return $this->error('请选择要删除的数据');
        }
        $city->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $cityIds = $this->request->param('cityIds/a');
        if(empty($cityIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($cityIds as $key=>$val){
            $cityIds[$key] = (int)$val;
        }
        CityModel::where([
            ['city_id','IN',$cityIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $cityId = $this->request->param('cityId/d');
        $datas = [
            'name'    => $this->request->param('name'),
            'lat'       => $this->request->param('lat'),
            'lng'    => $this->request->param('lng'),
            'is_open'      => $this->request->param('is_open/d'),
            'is_hot'       => $this->request->param('is_hot/d'),
        ];
        if(empty($datas['name'])){
            return $this->error('请输入城市名称');
        }
        if(empty($datas['lat']) || empty($datas['lng'])){
            return $this->error('请选择城市坐标');
        }
        
        if(!empty($cityId)){
            if(null === $city = CityModel::find($cityId)){
                return $this->error('请选择要编辑的城市');
            }
        }else{
            $city = new CityModel();
        }
        $city->save($datas);
        return $this->success();
    }
    
}