<?php
namespace app\admin\controller\data;
use app\BaseController;
use app\common\model\data\BannerModel;
class  Banner extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','IN',[0,$cityId]];
        }
        $return['count'] = BannerModel::where($where)->count();
        $return['datas'] = BannerModel::with(['city'])->where($where)
                           ->order(['sort'=>'desc', 'id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()
                           ->toArray();
        return $this->success($return);
    }
    
    public function del(){
        $id = $this->request->param('id/d');
        if(empty($id)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $banner = BannerModel::find($id)){
            return $this->error('请选择要删除的数据');
        }
        $banner->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $ids = $this->request->param('ids/a');
        if(empty($ids)){
            return $this->error('请选择要删除的数据');
        }
        foreach($ids as $key=>$val){
            $ids[$key] = (int)$val;
        }
        BannerModel::where([
            ['id','IN',$ids]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $id = $this->request->param('id/d');
        $datas = [
            'photo'    => $this->request->param('photo'),
            'city_id'    => $this->request->param('city_id/d'),
            'sort'      => $this->request->param('sort/d'),
            'link_type' => $this->request->param('link_type/d'),
            'link_appid' => $this->request->param('link_appid'),
            'link_path' => $this->request->param('link_path'),
        ];
        if(empty($datas['photo'])){
            return $this->error('请上传BANNER');
        }
        
        if(!empty($id)){
            if(null === $banner = BannerModel::find($id)){
                return $this->error('请选择要编辑的Banner');
            }
        }else{
            $banner = new BannerModel();
        }
        $banner->save($datas);
        return $this->success();
    }
    
}