<?php
namespace app\admin\controller\cloud;
use app\BaseController;
use app\common\model\data\SettingModel;
use app\common\logic\cloud\CloudLogic;
use app\common\logic\setting\SettingLogic;
use think\Exception;
class Index extends BaseController{
    
    public function regsiter(){
        $datas = [
            'site_name' => $this->request->param('site_name'),
            'name'      => $this->request->param('name'),
            'mobile'    => $this->request->param('mobile'),
            'host'      => $_SERVER['HTTP_HOST'],
            'app_id'    => 1,
        ];
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->request('registerSiteInfo',$datas,false);
            $val = [
                'code' => $res['code'],
                'miniapp_v' => '1.0',
                'php_v'     => '1.0'
            ];
            if(null === $data = SettingModel::where([['k','=','cloud']])->find()){
                $model = new SettingModel();
                $model->save([
                    'k' => 'cloud',
                    'v' => $val,   
                ]);
            }else{
                $data->v = $val;
                $data->save();
            }
            SettingLogic::getInstance()->clearCached();
            return $this->success();
        } catch (Exception $e){
            return $this->error($e->getMessage());
        } 
        
    }
    
    public function code(){
        $code = $this->request->param('code');
        if(empty($code)){
            return $this->error('请输入激活码');
        }
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->request('checkCode',['code'=>$code],false);
        } catch (Exception $e){
            return $this->error($e->getMessage());
        }
       
        $val = [
            'code' => $code,
            'miniapp_v' => '1.0',
            'php_v'     => '1.0'
        ];
        if(null === $data = SettingModel::where([['k','=','cloud']])->find()){
            $model = new SettingModel();
            $model->save([
                'k' => 'cloud',
                'v' => $val,   
            ]);
        }else{
            $data->v = $val;
            $data->save();
        }
        SettingLogic::getInstance()->clearCached();
        return $this->success();
    }
    
  
    public function getCloudHomeInfo(){
        $cloud = SettingLogic::getInstance()->getDataByKey('cloud');
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->request('getHomeInfo',[
                'miniapp_v' => $cloud ? $cloud['miniapp_v'] : '1.0',
                'php_v' => $cloud ? $cloud['php_v'] : '1.0',
            ]);
        } catch (Exception $e){
            return $this->error($e->getMessage());
        }
       
       
        $res['php_v'] = $cloud ? $cloud['php_v'] : '1.0';
        $res['miniapp_v'] = $cloud ? $cloud['miniapp_v'] : '1.0';
        return $this->success($res);
    }
    
}
