<?php
namespace app\admin\controller\cloud;
use app\BaseController;
use app\common\logic\cloud\CloudLogic;
use think\Exception;
use think\facade\Db;
use app\common\logic\setting\SettingLogic;
use ZipArchive;
use app\common\model\data\SettingModel;
class App extends BaseController{
    
    public function getAppV(){
        $v = $this->request->param('v'); // 一般情况下在初次安装的时候没有版本号出现 也就是用户数据库里面没有APP
        if(!empty($v)){
            $datas['v'] = $v;
        }
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->request('getAppV',$datas);
        } catch (Exception $e){
            return $this->error($e->getMessage());
        }
        return $this->success($res);
    }
    
    public function getAppFile(){

        $v = $this->request->param('v'); //这个是 getAppV后的版本号
        $dir = root_path().'phpCode/'.$v;
        if(!is_dir($dir)){
            mkdir($dir,0777,true);
        }
        $file = $dir.'/'.$v.'.zip';
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->download('getAppFile',[
                'v' => $v
            ],$file);
        } catch (Exception $e){
            return $this->error($e->getMessage());
        }
        return $this->success();
    }
    //解压
    public function decompressionPhpFile(){
        $qqmap = SettingLogic::getInstance()->getDataByKey('qqmap');
        
        $v = $this->request->param('v'); //这个是 getAppV后的版本号
        $dir = root_path().'phpCode/'.$v;
        $file = $dir.'/'.$v.'.zip';
        $zip=new ZipArchive;//新建一个ZipArchive的对象 
        if($zip->open($file)===TRUE){ 
            $zip->extractTo($dir); 
            $zip->close();
            unlink($file);
            $jsdir = [
                $dir .'/manage/assets/',
                $dir.'/h5/assets/'
            ];
            $domain = $_SERVER['HTTP_HOST'];
            foreach($jsdir as $d){
                if(is_dir($d)){
                    $files = scandir($d);
                    foreach($files as $val){
                        if(strstr($val,'.js')){
                            $str = file_get_contents($d.$val);
                            $str = preg_replace('/pin\.pinyuyu\.com/',$domain, $str);
                            if(!empty($qqmap) && !empty($qqmap['key'])){
                                $str = preg_replace('/UT6BZ\-CJDEP\-HPJD7\-L6RGE\-JNC6O\-KSFPM/',$qqmap['key'], $str);
                            }
                            file_put_contents($d.$val, $str);
                        }
                    }
                }
            }
            return $this->success('解压文件成功');
        }else{
            return $this->error('解压文件失败');
        }         
        
    }
    
    public function movePhpFile(){
        $v = $this->request->param('v');
        if(empty($v)){
            return $this->error('要升级的版本不正确');
        }
        $dir = root_path().'phpCode/'.$v;
        $phpdir = $dir.'/php/';
        $manageDir = $dir.'/manage/';
        $h5Dir = $dir.'/h5/';
        if(is_dir($phpdir)){
            $res = doMoveDir($phpdir, root_path());
            if($res == false) return $this->error ('复制应用PHP文件失败');
        }
        if(is_dir($manageDir)){
            $res = doMoveDir($manageDir, root_path().'public/superadmin/');
            if($res == false) return $this->error ('复制应用后台文件失败');
        }
        if(is_dir($h5Dir)){
            $res = doMoveDir($h5Dir, root_path().'public/h5/');
            if($res == false) return $this->error ('复制公众号失败');
        }
        return $this->success('复制文件成功');
    }
    
    public function installPhpSql(){
        $v = $this->request->param('v');
        if(empty($v)){
            return $this->error('要升级的版本不正确');
        }
        $dir = root_path().'phpCode/'.$v;
        $sqlFile = $dir.'/update.sql';
        if(!file_exists($sqlFile)){
            return $this->success('执行成功');
        }
        $sql = file_get_contents($sqlFile);
        $sqls = explode(';'."\r", $sql);
        if(empty($sql)) return $this->success ('执行成功');
        Db::startTrans();
        try{
            foreach($sqls as $val){
               $val = trim($val);
               if(!empty($val)){
                  Db::execute($val);
               }
            }
            Db::commit();
            return $this->success ('执行成功');
        } catch (\Exception $e){
            Db::rollback();
            return $this->error($e->getMessage());
        }
    }
 
    public function overPhpUpdate(){
        $v = $this->request->param('v');
        try{
           if(null === $data = SettingModel::where([['k','=','cloud']])->find()){
                return $this->error('您还未激活站点不能做此操作');
            }
            $cloud = $data->v;
            $cloud['php_v'] = $v;
            $data->save([
                'v' =>  $cloud
            ]);
            SettingLogic::getInstance()->clearCached();
            return $this->success('安装成功');
        }
        catch (\Exception $e){
            return $this->error($e->getMessage());
        }
    }
     
    public function getMiniappV(){
       
        $v = $this->request->param('v'); // 一般情况下在初次安装的时候没有版本号出现 也就是用户数据库里面没有APP
        if(!empty($v)){
            $datas['v'] = $v;
        }
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->request('getMiniappV',$datas);
        } catch (Exception $e){
            return $this->error($e->getMessage());
        }
        return $this->success($res);
    }
    
    public function planMiniappResource(){
       
        $v = $this->request->param('v');
        $miniapp = SettingLogic::getInstance()->getDataByKey('miniapp');
        if(empty($miniapp)){
            return $this->error('请先配置小程序参数');
        }
        $datas = [
            'v'            => $v,
            'wxAppId'      => $miniapp['app_id'],
            'wxUploadKey'  => $miniapp['upload_cert'],
        ];
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->request('planMiniappResource',$datas);
        } catch (Exception $e){
            return $this->error($e->getMessage());
        }
        return $this->success();
    }
    public function uploadMiniapp(){
        $miniapp = SettingLogic::getInstance()->getDataByKey('miniapp');
        if(empty($miniapp)){
            return $this->error('请先配置小程序参数');
        }
        $datas = [
            'wxAppId'      => $miniapp['app_id']
        ];
        try{
            $CloudLogic = new CloudLogic();
            $res = $CloudLogic->request('uploadMiniapp',$datas);
        } catch (Exception $e){
            return $this->error($e->getMessage());
        }
        return $this->success();
    }
    
    public function overMiniapp(){
        $v = $this->request->param('v');
        try{
           if(null === $data = SettingModel::where([['k','=','cloud']])->find()){
                return $this->error('您还未激活站点不能做此操作');
            }
            $cloud = $data->v;
            $cloud['miniapp_v'] = $v;
            $data->save([
                'v' =>  $cloud
            ]);
            SettingLogic::getInstance()->clearCached();
            return $this->success('安装成功');
        }
        catch (\Exception $e){
            return $this->error($e->getMessage());
        }
    }
    
    
}