<?php
namespace app\admin\controller\angling;
use app\BaseController;
use app\common\model\angling\TuanModel;
class Tuan extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['title','LIKE','%'.$keyword.'%'];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        
        $return['count'] = TuanModel::where($where)->count();
        $return['datas'] = TuanModel::with(['angling'=>function($query){
            $query->field('angling_id,name');
        }])->where($where)
                           ->order(['tuan_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
   
    
    public function del(){
        $tuanId = $this->request->param('tuanId/d');
        if(empty($tuanId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $tuan = TuanModel::find($tuanId)){
            return $this->error('请选择要删除的数据');
        }
        $tuan->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $tuanIds = $this->request->param('tuanIds/a');
        if(empty($tuanIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($tuanIds as $key=>$val){
            $tuanIds[$key] = (int)$val;
        }
        TuanModel::where([
            ['tuan_id','IN',$tuanIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $tuanId = $this->request->param('tuanId/d');
        $datas = [
            'angling_id'    => $this->request->param('angling_id/d'),
            'title'      => $this->request->param('title'),   
            'price'      => round($this->request->param('price/f'),2),
            'original_price'      => round($this->request->param('original_price/f'),2),
            'num'       => $this->request->param('num/d'),
            'day'       => $this->request->param('day'),
        ];
        if(empty($datas['angling_id'])){
            return $this->error('请选择黑坑商家');
        }
        if(empty($datas['title'])){
            return $this->error('请填写团购标题');
        }
        if(empty($datas['day'])){
            return $this->error('请填写使用日期限制');
        }
        if(!empty($tuanId)){
            if(null === $tuan = TuanModel::find($tuanId)){
                return $this->error('请选择要编辑的数据');
            }
        }else{
            $tuan = new TuanModel();
        }
        $tuan->save($datas);
        return $this->success();
    }
    
}