<?php
namespace app\admin\controller\angling;
use app\BaseController;
use app\common\model\angling\MoneyLogModel;
use app\common\model\angling\CashModel;
class Money extends BaseController{
    
    public function index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['angling_id','LIKE','%'.$keyword.'%'];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        $return['count'] = MoneyLogModel::where($where)->count();
        $return['datas'] = MoneyLogModel::with(['angling'=>function($query){
            $query->field('angling_id,name');
        }])->where($where)
                           ->order(['log_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    public function cash(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['angling_id|bank_name|bank_account','LIKE','%'.$keyword.'%'];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        $status = $this->request->param('status/d');
        if(!empty($status)){
            $status = $status == 1 ? 1 : 0;
            $where[] = ['status','=',$status];
        }
        $return['count'] = CashModel::where($where)->count();
        $return['datas'] = CashModel::with(['angling'=>function($query){
            $query->field('angling_id,name');
        }])->where($where)
                           ->order(['log_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    public function changeCashStatus(){
        $logId = $this->request->param('logId/d');
        if(empty($logId)){
            return $this->error('请选择要确认的数据');
        }
        if(null === $log = CashModel::find($logId)){
            return $this->error('请选择要确认的数据');
        }
        $log->status = 1;
        $log->save();
        return $this->success();
    }
    
    
}