<?php
namespace app\admin\controller\angling;
use app\BaseController;
use app\common\model\angling\ManageModel;
class Manage extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['angling_id|member_id','LIKE','%'.$keyword.'%'];
        }
        $member_id = $this->request->param('memberId/d');
        if(!empty($member_id)){
            $where[] = ['member_id','=',$member_id];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        $return['count'] = ManageModel::where($where)->count();
        $return['datas'] = ManageModel::with(['member'=>function($query){
            $query->field('member_id,nickname,mobile');
        },'angling'=>function($query){
            $query->field('angling_id,name');
        }])->where($where)
                           ->order(['id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
   
    
    public function del(){
        $manageId = $this->request->param('id/d');
        if(empty($manageId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $manage = ManageModel::find($manageId)){
            return $this->error('请选择要删除的数据');
        }
        $manage->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $manageIds = $this->request->param('ids/a');
        if(empty($manageIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($manageIds as $key=>$val){
            $manageIds[$key] = (int)$val;
        }
        ManageModel::where([
            ['id','IN',$manageIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $datas = [
            'member_id'    => $this->request->param('member_id/d'),
            'angling_id'    => $this->request->param('angling_id/d'),
            'role'          => $this->request->param('role/d'),
        ];
        if(empty($datas['member_id'])){
            return $this->error('请选择用户');
        }
        if(empty($datas['angling_id'])){
            return $this->error('请选择黑坑商家');
        }
        $has = ManageModel::where([
            ['member_id','=',$datas['member_id']],
            ['angling_id','=',$datas['angling_id']]
        ])->find();
        if(null !== $has){
            return $this->error('该账号已经存在');
        }
        $manage = new ManageModel();       
        $manage->save($datas);
        return $this->success();
     
     
    }
    
}