<?php
namespace app\admin\controller\angling;
use app\BaseController;
use app\common\model\angling\FreeModel;
class Free extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['angling_id','LIKE','%'.$keyword.'%'];
        }
        $angling_id = $this->request->param('anglingId/d');
        if(!empty($angling_id)){
            $where[] = ['angling_id','=',$angling_id];
        }
        $return['count'] = FreeModel::where($where)->count();
        $return['datas'] = FreeModel::with(['angling'=>function($query){
            $query->field('angling_id,name');
        }])->where($where)
                           ->order(['free_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
   
    
    public function del(){
        $freeId = $this->request->param('freeId/d');
        if(empty($freeId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $free = FreeModel::find($freeId)){
            return $this->error('请选择要删除的数据');
        }
        $free->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $freeIds = $this->request->param('freeIds/a');
        if(empty($freeIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($freeIds as $key=>$val){
            $freeIds[$key] = (int)$val;
        }
        FreeModel::where([
            ['free_id','IN',$freeIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $freeId = $this->request->param('freeId/d');
        $datas = [
            'angling_id'    => $this->request->param('angling_id/d'),
            'free'      => round($this->request->param('free/f'),2),
            'level'       => $this->request->param('level/d'),    
            'bg_time'     => $this->request->param('bg_time'),  
            'end_time'    => $this->request->param('end_time'),
        ];
        if(empty($datas['angling_id'])){
            return $this->error('请选择黑坑商家');
        }
        if(!empty($freeId)){
            if(null === $free = FreeModel::find($freeId)){
                return $this->error('请选择要编辑的费率类型');
            }
        }else{
            $free = new FreeModel();
        }
        $free->save($datas);
        return $this->success();
    }
    
}