<?php
namespace app\admin\controller\angling;
use app\BaseController;
use app\common\model\angling\AnglingModel;
class  Angling extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['name','LIKE','%'.$keyword.'%'];
        }
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        
        $type = $this->request->param('type/d');
        if(!empty($type)){
            if($type == 1){
                $where[] = ['is_audit','=',0];
            }else{
                $where[] = ['is_audit','=',1];
            }
        }
        
        $return['count'] = AnglingModel::where($where)->count();
        $return['datas'] = AnglingModel::with(['city'])->where($where)
                           ->order(['angling_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
   
    
    public function del(){
        $anglingId = $this->request->param('anglingId/d');
        if(empty($anglingId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $angling = AnglingModel::find($anglingId)){
            return $this->error('请选择要删除的数据');
        }
        $angling->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $anglingIds = $this->request->param('anglingIds/a');
        if(empty($anglingIds)){
            return $this->error('请选择要删除的数据');
        }
        foreach($anglingIds as $key=>$val){
            $anglingIds[$key] = (int)$val;
        }
        AnglingModel::where([
            ['angling_id','IN',$anglingIds]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $anglingId = $this->request->param('anglingId/d');
        $datas = [
            'name'    => $this->request->param('name'),
            'photos'      => $this->request->param('photos/a'),
            'detail'        => $this->request->param('detail'),  
            'lat'         => $this->request->param('lat'),
            'lng'         => $this->request->param('lng'),
            'mobile'       => $this->request->param('mobile'),
            'weixin'       => $this->request->param('weixin'), 
            'city_id'     => $this->request->param('city_id/d'),
            'is_tai'     => $this->request->param('is_tai/d'),
            'is_lure'      => $this->request->param('is_lure/d'),  
            'is_audit'      => $this->request->param('is_audit/d'),  
            'fish_type'   => $this->request->param('fish_type/a'),
            'addr'         => $this->request->param('addr'), 
            'rank_num'     => $this->request->param('rank_num/d'), 
        ];
        if(empty($datas['name'])){
            return $this->error('请填写钓场名称');
        }
        if(empty($datas['photos'])){
            return $this->error('请上传图片');
        }
        if(empty($datas['detail'])){
            return $this->error('请填写钓场说明');
        }
        if(empty($datas['lat']) || empty($datas['lng'])){
            return $this->error('请选择钓场的经纬度坐标');
        }
        if(!is_mobile($datas['mobile'])){
            return $this->error('联系方式不能为空');
        }
        if(empty($datas['weixin'])){
            return $this->error('微信号码不能为空');
        }
        if(!empty($anglingId)){
            if(null === $angling = AnglingModel::find($anglingId)){
                return $this->error('请选择要编辑的用户');
            }
        }else{
            $angling = new AnglingModel();
        }
        
        $angling->save($datas);
        return $this->success();
     
     
    }
    
}