<?php
namespace app\admin\controller\admin;
use app\BaseController;
use app\common\logic\admin\AdminLogic;
use think\exception\ValidateException;
use app\common\validate\admin\AdminValidate;
use app\common\model\admin\AdminModel;
class Index extends BaseController{
    
    /**
     * 编辑个人资料
     */
    public function update(){
        $adminId = $this->request->adminId;
        $adminLogic = AdminLogic::getInstance($adminId);
        if(null === $adminLogic){
            return $this->error('用户不存在');
        }
        $data = [];
        $data['name']   = $this->request->param('name');
        $data['mobile'] = $this->request->param('mobile');
        $password = $this->request->param('password');
        try{
            validate(AdminValidate::class)->scene('update')->check($data);
        }  catch (ValidateException $e) {
            // 验证失败 输出错误信息
           return $this->error($e->getMessage());
        }
        if(!empty($password)){
            if(strlen($password) < 6 || strlen($password) > 32){
                return $this->error('密码应该在6至32位之间');
            }
            $data['password'] = md5($password);
        }
        $adminLogic->setData($data)->save();
        return $this->success('更新成功');
    }
    
    /***
     * 账号列表
     */
    
    public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['username|name|mobile','LIKE','%'.$keyword.'%'];
        }
        $where[] = ['is_delete','=',0];
        $return['count'] = AdminModel::where($where)->count();
        $return['datas'] = AdminModel::where($where)->field('admin_id,username,mobile,name,role,add_time,last_time')
                            ->order(['admin_id'=>'desc'])
                           ->limit($limit)->page($page)
                           ->select()
                           ->append(['last_time_format','add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    /**
     * 获取资料
     */
    public function detail(){
        $adminId = $this->request->param('adminId/d');
        if(empty($adminId)){
            return $this->error('您要获取的用户数据不存在');
        }
        if(null === $admin = AdminModel::find($adminId)){
            return $this->error('您要获取的用户数据不存在');
        }
        return $this->success([
            'detail' => [
                'adminId' => $admin->admin_id,
                'name'    => $admin->name,
                'username' => $admin->username,
                'password' => '',
                'mobile'   => $admin->mobile,
                'role'     => $admin->role,
            ],
        ]);
    }
    
    /**
     * 删除账号
     */
    
    public function del(){
        $adminId = $this->request->param('adminId/d');
        if(empty($adminId)){
            return $this->error('您要删除的账号数据不存在');
        }
        if(null === $admin = AdminModel::find($adminId)){
            return $this->error('您要删除的账号数据不存在');
        }
        if($admin->is_delete == 1){
            return $this->error('该账号已经被删除了');
        }
        if($admin->role == 1){
            return $this->error('超级管理员不能删除');
        }
        $admin->is_delete = 1;
        $admin->save();
        return $this->success('删除成功');
    }
    
    public function delAll(){
        $adminIds = $this->request->param('adminIds/a');
        if(!empty($adminIds)){
            foreach($adminIds as $k=>$v){
                $adminIds[$k] = (int) $v;
            }
            $adminModel = new AdminModel();
            $adminModel->where([
                ['admin_id','IN',$adminIds],
                ['role','=',2]
            ])->save([
                'is_delete' => 1
            ]);
            return $this->success('删除成功');
        }else{
            return $this->error('请选择要删除的管理员'); 
        }
       
    }
    
    /***
     * 编辑账号
     */
    public  function edit(){
        $adminId = $this->request->param('adminId/d');
        if(empty($adminId)){
            return $this->error('您要获取的用户数据不存在');
        }
        if(null === $admin = AdminModel::find($adminId)){
            return $this->error('您要获取的用户数据不存在');
        }
        $data = [];
        $data['name'] = $this->request->param('name');
        $data['role'] = $this->request->param('role');
        $data['mobile'] = $this->request->param('mobile');
        $password = $this->request->param('password');
        try{
            validate(AdminValidate::class)->scene('edit')->check($data);
        }  catch (ValidateException $e) {
            // 验证失败 输出错误信息
           return $this->error($e->getMessage());
        }
        if(!empty($password)){
            if(strlen($password) < 6 || strlen($password) > 32){
                return $this->error('密码应该在6至32位之间');
            }
            $data['password'] = md5($password);
        }
        
        $admin->save($data);
        return $this->success('操作成功');
    }
    
    /***
     * 新建账号
     */
    public function add(){
        $data = [];
        $data['name'] = $this->request->param('name');
        $data['username']   = $this->request->param('username');
        $data['role'] = $this->request->param('role');
        $data['mobile'] = $this->request->param('mobile');
        $password = $this->request->param('password');
        $isHas = AdminModel::where([['username','=',$data['username']],['is_delete','=',0]])->count();
        if($isHas > 0){
            return $this->error('账号已经存在');
        }
        try{
            validate(AdminValidate::class)->scene('add')->check($data);
        }  catch (ValidateException $e) {
            // 验证失败 输出错误信息
           return $this->error($e->getMessage());
        }
        if(strlen($password) < 6 || strlen($password) > 32){
            return $this->error('密码应该在6至32位之间');
        }
        $data['password'] = md5($password);
        $adminModel = new AdminModel();
        $adminModel->save($data);
        return $this->success('添加成功');
    }
    
    
}