<?php
namespace app\admin\controller;
use app\BaseController;
use app\common\helper\token\TokenHelper;
use app\common\model\admin\AdminModel;
use app\common\logic\setting\SettingLogic;
class Login extends BaseController{
    
    //后台登陆入口
    public function index()
    {
        $username=$this->request->param('username');
        $password=$this->request->param('password');
        if(empty($username)){
            return $this->error('请输入用户名');
        }
        if(empty($password)){
            return $this->error('请输入登录密码');
        }
        $where = [
            ['username','=',$username],
            ['is_delete','=',0]
        ];
        if(null === $admin = AdminModel::where(['username'=>$username])->find()){
            return $this->error('用户名或密码不正确');
        }
        if($admin->password != md5($password)){
            return $this->error('用户名或密码不正确');
        }
        $admin->last_time = time();
        $admin->save();
        $cloud = SettingLogic::getInstance()->getDataByKey('cloud');
        $return = [
            'token'     => TokenHelper::getToken($admin->admin_id),
            'admin'     => [
                'admin_id' => $admin->admin_id,
                'name' => $admin->name,
                'mobile' => $admin->mobile,
                'last_time' => $admin->last_time_format,
                'role'  => $admin->role,
            ],
            'cloud' => $cloud == null ? 0 : 1,
        ];
        return $this->success($return);
    }

    
    
    
}