<?php
namespace app\admin\controller;
use app\BaseController;
use app\common\model\member\MemberModel;
use app\common\model\order\OrderModel;
use app\common\model\angling\AnglingModel;
use app\common\model\rapac\RapacModel;
class  Index extends BaseController{
    
        
    public function getCount(){
        
        $shop = AnglingModel::count() ?? 0;
        $rapac = RapacModel::count() ?? 0;
        $member = MemberModel::count() ?? 0;
        $order = OrderModel::count() ?? 0;
        $money = OrderModel::where([
            ['is_paid','=',1],
        ])->sum('total_price') ?? 0;
        $tmoney = OrderModel::where([
            ['is_paid','=',1],
        ])->whereDay('add_time')->sum('total_price') ?? 0;
        
        return $this->success([
            'datas' => [
                'shop' => $shop,
                'rapac' => $rapac,
                'member' => $member,
                'order' => $order,
                'money' => $money,
                'tmoney' => $tmoney
            ]
        ]);
    }
    public function getOrderCount(){
        $t = time() - 7 * 86400;
        $days = [];
        $nums = [];
        $money = [];
        for($i=1;$i<7;$i++){
            $d = date('Y-m-d',$t+$i*86400);
            $n = OrderModel::where('is_paid',1)->whereDay('add_time',$d)->count() ?? 0;
            $m = OrderModel::where('is_paid',1)->whereDay('add_time',$d)->sum('total_price') ?? 0;
            $nums[] = $n;
            $money[] = $m;
            $days[] = date('m月d',$t+$i*86400);
        }
        return $this->success([
            'nums' => $nums,
            'days'  => $days,
            'money' => $money
        ]);
    }
    
    
    public function getMemberCount(){
        $t = time() - 7 * 86400;
        $days = [];
        $datas = [];
        for($i=1;$i<7;$i++){
            $d = date('Y-m-d',$t+$i*86400);
            $c = MemberModel::whereDay('add_time',$d)->count() ?? 0;
            $datas[] = $c;
            $days[] = date('m月d',$t+$i*86400);
        }
        return $this->success([
            'datas' => $datas,
            'days'  => $days
        ]);
    }
   
    
}