<?php
namespace app;
trait  BaseTrait{


    /**
     * 返回成功json
     * @param mixed $data 返回的数据
     * @param integer $code 状态码
     * @param array $header 头部
     * @param array $options 参数
     * @return \think\response\Json
     */

    public function success($data = [], $code = 200, $msg = "操作成功", $header = [])
    {
        
        $result = [
            'code' => $code,
            'msg' => $msg,
            'time' => request()->time(),
            'data' => $data,
        ];
        return json($result, 200, $header);
    }

    /**
     * 获取\think\response\Json对象实例
     * @param mixed $data 返回的数据
     * @param integer $code 状态码
     * @param array $header 头部
     * @param array $options 参数
     * @return \think\response\Json
     */
    public function error($msg = "网络异常，请重试", $code = 400, $data = [], $header = [])
    {
        $result = [
            'code' => $code,
            'msg' => $msg,
            'time' => request()->time(),
            'data' => $data,
        ];
        return json($result, 200, $header);
    }
}